/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Legende;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.ServerMocQuery;
import cds.tools.MultiPartPostOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Vector;

public class ServerXmatch
extends ServerMocQuery {
    private static final boolean TEST = true;
    private String separation = null;
    private String selection = null;

    @Override
    protected void init(Aladin aladin) {
        this.type = 2;
        this.title = "X-match query";
        this.aladinLabel = "X-match";
        this.title1 = "Choose a local table";
        this.title2 = "Catalog to x-match";
        this.baseUrl = "http://cdsxmatch.cds.unistra.fr/xmatch/api/v1/sync";
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = "X-match query";
    }

    protected ServerXmatch(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected Vector<Plan> getPlans() {
        return this.aladin.calque.getPlans(PlanCatalog.class);
    }

    @Override
    protected String getPlanName() {
        String s = this.planName == null ? this.getCatName() : this.planName;
        return s + " via Xmatch";
    }

    @Override
    protected String getCatName() {
        String s = super.getCatName();
        if (s.endsWith("Simbad")) {
            return "simbad";
        }
        if (s.startsWith("CDS/")) {
            return "vizier:" + s.substring(4);
        }
        return s;
    }

    @Override
    protected void addUpload(MultiPartPostOutputStream out, Plan plan) throws Exception {
        Legende leg = plan.getFirstLegende();
        boolean addCoo = false;
        int raIndex = leg.getRa();
        int deIndex = leg.getDe();
        String dataType = leg.getDataType(raIndex);
        String unit = leg.getUnit(raIndex);
        String raName = "_RAJ2000";
        String deName = "_DEJ2000";
        addCoo = true;
        out.writeField("colRA1", raName);
        out.writeField("colDec1", deName);
        Aladin.trace(4, "with local plan=" + plan.getLabel() + " " + plan.getCounts() + "src RA=" + raName + " DE=" + deName + "...");
        File file = File.createTempFile("tmp", "xml");
        file.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.aladin.writePlaneInVOTable(plan, dos, addCoo, false);
        dos.close();
        out.writeFile("cat1", null, file, false);
    }

    protected void setSeparation(String separation) {
        this.separation = separation;
    }

    protected String getSeparation() {
        if (this.separation != null) {
            return this.separation;
        }
        return "";
    }

    protected void setSelection(String selection) {
        this.selection = selection;
    }

    protected String getSelection() {
        if (this.selection != null) {
            return this.selection;
        }
        return "";
    }

    @Override
    protected void addParameter(MultiPartPostOutputStream out) throws Exception {
        String catName = this.getCatName();
        Aladin.trace(4, "Xmatch [" + catName + "]...");
        out.writeField("REQUEST", "xmatch");
        out.writeField("cat2", catName);
        String separation = this.getSeparation();
        if (separation.length() == 0) {
            separation = "5";
        }
        out.writeField("distMaxArcsec", separation);
        String selection = this.getSelection();
        if (selection.length() == 0) {
            selection = "best";
        }
        out.writeField("selection", selection);
        out.writeField("RESPONSEFORMAT", "votable");
        String limit = this.getLimit();
        if (limit.length() == 0) {
            limit = "unlimited";
        }
        if (!limit.equals("unlimited")) {
            limit = limit.replaceAll(",", "");
            out.writeField("MAXREC", limit);
        }
    }

    @Override
    protected void log() {
        this.aladin.log("XmatchQuery", this.getPlan().getLabel() + " " + super.getCatName());
    }
}

